<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id']) || empty($input['id'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID del bien no especificado']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "
        UPDATE bienes SET 
            denominacion_id = ?,
            descripcion_individual = ?,
            estado_id = ?,
            clase_id = ?,
            ubicacion_id = ?,
            responsable_id = ?,
            observaciones = ?
        WHERE id = ?
    ";
    
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([
        $input['denominacion_id'],
        $input['descripcion_individual'] ?? null,
        $input['estado_id'],
        $input['clase_id'] ?? null,
        $input['ubicacion_id'] ?? null,
        $input['responsable_id'] ?? null,
        $input['observaciones'] ?? null,
        $input['id']
    ]);
    
    if ($success) {
        echo json_encode([
            'success' => true,
            'message' => 'Bien actualizado exitosamente'
        ]);
    } else {
        throw new Exception('Error al actualizar el bien');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al actualizar bien: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>