<?php
require_once 'conexion.php';

try {
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $combos = [];
    
    // Consultar denominaciones
    $sql_denominaciones = "SELECT id, codigo_patrimonial, denominacion FROM denominaciones ORDER BY denominacion";
    $stmt = $db->prepare($sql_denominaciones);
    $stmt->execute();
    $combos['denominaciones'] = $stmt->fetchAll();
    
    // Consultar estados
    $sql_estados = "SELECT id, nombre FROM estados ORDER BY nombre";
    $stmt = $db->prepare($sql_estados);
    $stmt->execute();
    $combos['estados'] = $stmt->fetchAll();
    
    // Consultar clases
    $sql_clases = "SELECT id, nombre FROM clases ORDER BY nombre";
    $stmt = $db->prepare($sql_clases);
    $stmt->execute();
    $combos['clases'] = $stmt->fetchAll();
    
    // Consultar ubicaciones
    $sql_ubicaciones = "SELECT id, nombre FROM ubicaciones ORDER BY nombre";
    $stmt = $db->prepare($sql_ubicaciones);
    $stmt->execute();
    $combos['ubicaciones'] = $stmt->fetchAll();
    
    // Consultar responsables
    $sql_responsables = "SELECT id, nombre, dni, correo, celular FROM responsables ORDER BY nombre";
    $stmt = $db->prepare($sql_responsables);
    $stmt->execute();
    $combos['responsables'] = $stmt->fetchAll();
    
    echo json_encode($combos, JSON_UNESCAPED_UNICODE);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al consultar combos: ' . $e->getMessage()
    ]);
}
?>