<?php
require_once 'conexion.php';

try {
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "SELECT id, codigo_patrimonial, denominacion FROM denominaciones ORDER BY denominacion";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $denominaciones = $stmt->fetchAll();
    
    echo json_encode($denominaciones, JSON_UNESCAPED_UNICODE);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al consultar denominaciones: ' . $e->getMessage()
    ]);
}
?>