<?php
require_once 'conexion.php';

try {
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "SELECT id, nombre FROM ubicaciones ORDER BY nombre";
    
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $ubicaciones = $stmt->fetchAll();
    
    echo json_encode($ubicaciones, JSON_UNESCAPED_UNICODE);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al consultar ubicaciones: ' . $e->getMessage()
    ]);
}
?>