<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['id'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El ID de la clase es requerido'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Verificar si la clase tiene bienes asociados
    $sql_check = "SELECT COUNT(*) as count FROM bienes WHERE clase_id = ?";
    $stmt = $db->prepare($sql_check);
    $stmt->execute([$input['id']]);
    $result = $stmt->fetch();
    
    if ($result['count'] > 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se puede eliminar la clase porque tiene bienes asociados'
        ]);
        exit();
    }
    
    // Eliminar la clase
    $sql_delete = "DELETE FROM clases WHERE id = ?";
    
    $stmt = $db->prepare($sql_delete);
    $success = $stmt->execute([$input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Clase eliminada exitosamente'
        ]);
    } else if ($stmt->rowCount() == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'No se encontró la clase a eliminar'
        ]);
    } else {
        throw new Exception('Error al eliminar la clase');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al eliminar clase: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>