<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['id'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID requerido']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Verificar si hay bienes asignados a este responsable
    $checkSql = "SELECT COUNT(*) as count FROM bienes WHERE responsable_id = ?";
    $checkStmt = $db->prepare($checkSql);
    $checkStmt->execute([$input['id']]);
    $result = $checkStmt->fetch();
    
    if ($result['count'] > 0) {
        http_response_code(409);
        echo json_encode([
            'success' => false,
            'message' => 'No se puede eliminar: el responsable tiene bienes asignados'
        ]);
        exit();
    }
    
    $sql = "DELETE FROM responsables WHERE id = ?";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([$input['id']]);
    
    if ($success && $stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Responsable eliminado exitosamente'
        ]);
    } else {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Responsable no encontrado'
        ]);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>