<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['nombre']) || empty($input['grupo_id'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El nombre de la clase y el grupo son requeridos'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Verificar que el grupo existe
    $sql_check = "SELECT COUNT(*) as count FROM grupos WHERE id = ?";
    $stmt = $db->prepare($sql_check);
    $stmt->execute([$input['grupo_id']]);
    $result = $stmt->fetch();
    
    if ($result['count'] == 0) {
        echo json_encode([
            'success' => false,
            'message' => 'El grupo seleccionado no existe'
        ]);
        exit();
    }
    
    // Insertar la nueva clase
    $sql_insert = "INSERT INTO clases (nombre, grupo_id) VALUES (?, ?)";
    
    $stmt = $db->prepare($sql_insert);
    $success = $stmt->execute([$input['nombre'], $input['grupo_id']]);
    
    if ($success) {
        echo json_encode([
            'success' => true,
            'message' => 'Clase registrada exitosamente',
            'id' => $db->lastInsertId()
        ]);
    } else {
        throw new Exception('Error al insertar la clase');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al insertar clase: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>