<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['nombre'])) {
        echo json_encode([
            'success' => false,
            'message' => 'El nombre del grupo es requerido'
        ]);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    // Insertar el nuevo grupo
    $sql_insert = "INSERT INTO grupos (nombre) VALUES (?)";
    
    $stmt = $db->prepare($sql_insert);
    $success = $stmt->execute([$input['nombre']]);
    
    if ($success) {
        echo json_encode([
            'success' => true,
            'message' => 'Grupo registrado exitosamente',
            'id' => $db->lastInsertId()
        ]);
    } else {
        throw new Exception('Error al insertar el grupo');
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error al insertar grupo: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>