<?php
require_once 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['nombre'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Nombre requerido']);
        exit();
    }
    
    $conexion = new Conexion();
    $db = $conexion->conectar();
    
    $sql = "INSERT INTO responsables (nombre, dni, correo, celular) VALUES (?, ?, ?, ?)";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([
        $input['nombre'],
        $input['dni'] ?? null,
        $input['correo'] ?? null,
        $input['celular'] ?? null
    ]);
    
    if ($success) {
        $nuevoId = $db->lastInsertId();
        echo json_encode([
            'success' => true,
            'message' => 'Responsable creado exitosamente',
            'id' => $nuevoId
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error al crear responsable']);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>